#ifndef CE2_TST_HMAC_H
#define CE2_TST_HMAC_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/
#include "CryptoEngine2.h"
#include "CE2_TST_Config.h"
#include <stdio.h>
#include <stdlib.h>
#include <io.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tew Mar 06 13:32:57 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains test functions for HMAC functions
* which worked with LibTomCrypt.
* 
* \version CE2_HMAC_TST.h#1:csrc:1
* \author Masiuk Aliaksandr
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/

/* General definitions */
#define TST_NAME_STRING_LEN 150
#define TST_FUNC_STRING_LEN 100
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536
#define TST_HMAC_MAX_KEY_SIZE 512

/* Default log file name */
#define TST_HMAC_STD_LOG_FILE_NAME "HMAC_TEST_LOG.TXT"

/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/

/* test data structure */
typedef struct TST_HMAC_TestDataStruct
{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t					TST_key[TST_HMAC_MAX_KEY_SIZE];
	DxUint16_t                  TST_keySize;	
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_input_dataSize;
	CE2_HASH_Result_t       	TST_HmacResultBuff;
	DxUint8_t 					TST_SHA1_Expected_output_data[CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES];
	DxUint16_t					TST_SHA1_Expected_dataSize;	
	DxUint8_t 					TST_MD5_Expected_output_data[CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES];
	DxUint16_t					TST_MD5_Expected_dataSize;	
    DxUint8_t 					TST_SHA224_Expected_output_data[CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA224_Expected_dataSize;	
    DxUint8_t 					TST_SHA256_Expected_output_data[CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA256_Expected_dataSize;	
    DxUint8_t 					TST_SHA384_Expected_output_data[CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA384_Expected_dataSize;
    DxUint8_t 					TST_SHA512_Expected_output_data[CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA512_Expected_dataSize;	
	CE2_HASH_OperationMode_t	TST_OperationMode;
} TST_HMAC_TestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/

/***************************************************************
* Function Name: 
*  CE2_TST_HMAC
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for HMAC integrated API
*  This function HMAC known vectors using SHA1 and MD5
*  Vector sizes used (in bytes) - 16/32/512/1536
*
* \b
* Algorithm:
*  -# Call the CE2_HMAC function to use the HMAC process;
*  -# Compare the outputted result to the expected one.
***************************************************************/
CE2Error_t CE2_TST_HMAC(FILE *out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_HMAC_H */
